from flask_wtf import FlaskForm
from wtforms import StringField, TextAreaField, SelectField, validators
from wtforms.validators import DataRequired, Email, Length

class ContactForm(FlaskForm):
    """Contact form for customer inquiries"""
    
    name = StringField('Full Name', 
                      validators=[DataRequired(message="Please enter your full name"),
                                Length(min=2, max=100, message="Name must be between 2 and 100 characters")])
    
    email = StringField('Email Address', 
                       validators=[DataRequired(message="Please enter your email address"),
                                 Email(message="Please enter a valid email address")])
    
    phone = StringField('Phone Number', 
                       validators=[DataRequired(message="Please enter your phone number"),
                                 Length(min=10, max=15, message="Please enter a valid phone number")])
    
    service_interest = SelectField('Service Interest', 
                                  choices=[
                                      ('general', 'General Inquiry'),
                                      ('auto', 'Auto Insurance'),
                                      ('health', 'Health Insurance'),
                                      ('life', 'Life Insurance'),
                                      ('property', 'Property Insurance'),
                                      ('business', 'Business Insurance')
                                  ],
                                  validators=[DataRequired(message="Please select a service")])
    
    message = TextAreaField('Message', 
                           validators=[DataRequired(message="Please enter your message"),
                                     Length(min=10, max=1000, message="Message must be between 10 and 1000 characters")])
